import { RumSessionTimeResponseSchema } from './../zod/rum-session-time.schema';
import { validatedFetch } from "@/lib/zod/validated-fetch";
import { env } from "@/env";
import { RumSiteVisitsResponseSchema } from "../zod/rum-site-visits.schema";
import { transformRumDailyVisitsResponse, transformRumMonthlyVisitsResponse, transformRumSessionTimeResponse } from "./transformers";

export async function fetchMonthlySiteVisits(monthCount: number) {
  const res = await validatedFetch({
    url: `${env.NEXT_PUBLIC_ANALYTICS_API_URL}/GetMonthlyVisitors/${monthCount}`,
    schema: RumSiteVisitsResponseSchema,
  });

  if (res instanceof Error) {
    throw new Error('Failed to fetch monthly site visits')
  }

  return transformRumMonthlyVisitsResponse(res)
}

export async function fetchDailySiteVisits(dayCount: number) {
  const res = await validatedFetch({
    url: `${env.NEXT_PUBLIC_ANALYTICS_API_URL}/GetDailyVisitors/${dayCount}`,
    schema: RumSiteVisitsResponseSchema,
  });

  if (res instanceof Error) {
    throw new Error('Failed to fetch daily site visits')
  }

  return transformRumDailyVisitsResponse(res)
}

export async function fetchMonthlySessionTime() {
  const res = await validatedFetch({
    url: `${env.NEXT_PUBLIC_ANALYTICS_API_URL}/MonthlyAverageSessionTime`,
    schema: RumSessionTimeResponseSchema,
  });

  if (res instanceof Error) {
    throw new Error('Failed to fetch monthly session time')
  }

  return transformRumSessionTimeResponse(res)
}

export async function fetchYearlySessionTime() {
  const res = await validatedFetch({
    url: `${env.NEXT_PUBLIC_ANALYTICS_API_URL}/YearlyAverageSessionTime`,
    schema: RumSessionTimeResponseSchema,
  });

  if (res instanceof Error) {
    throw new Error('Failed to fetch yearly session time')
  }

  return transformRumSessionTimeResponse(res)
}